// This file is used to create the import figures. 



*-------------------------------------------------------------------------------
clear all
set more off
set scheme plottig
cap cd "/Users/sbustos/Dropbox/Response Sachs-Weisbrot/Final_Data_Code/Data" 
*-------------------------------------------------------------------------------
 

loc lastyear 2017 // latest year available. 
loc minyear 2000 // min year shown. 
loc benchmarkyear 2013 // Used to index values to 100 on a given year




/*
*-------------------------------------------------------------------------------
tempfile tempwdi
use "../../datasets/WDI/wdi_extended.dta", clear
keep year region iso sp_pop_totl  ny_gdp_mktp_kd  ny_gdp_mktp_cd
drop if region==""
drop region
gen price = ny_gdp_mktp_cd / ny_gdp_mktp_kd
gen temp = price if iso=="USA"
egen index = mean(temp), by(year)
keep year iso index sp_pop_totl
drop if year<1995 | year>`lastyear'
save `tempwdi'
*-------------------------------------------------------------------------------

*-------------------------------------------------------------------------------
tempfile venimports
loc start `minyear'
loc end `lastyear'
forval y=`start'/`end' {
	quietly {
		noi di "doing year = `y'"
		use  "D:\data\trade_data\H0\H0_`y'.dta", clear
		
		//keep if importer=="VEN"
		gen byte tokeep = 0
		foreach i in ARG BRA CHL COL ECU PAN PER VEN BOL PRY URY {
			cap replace tokeep = 1 if importer=="`i'"
		}
		keep if tokeep
		collapse (sum)  export_value  , by(year importer commoditycode) 
		rename export_value import_value 
		if year>`start' {
			append using `venimports'
		}
		save `venimports', replace 
	}	
}
sort year commoditycode 
save "D:\Dropbox\Bustos-Santos\Medicine_Food\H0_imports_venezuela", replace
*-------------------------------------------------------------------------------
*/



loc start `minyear'
loc end `lastyear'
*-------------------------------------------------------------------------------
use "H0_imports_venezuela", replace
keep if year>=2000
		gen byte tokeep = 0
		foreach i in ARG BRA CHL COL ECU PAN PER VEN BOL PRY URY {
			cap replace tokeep = 1 if importer=="`i'"
		}
		keep if tokeep 
		gen medicine = import_value if substr(commoditycode, 1,4)=="3001" | substr(commoditycode, 1,4)=="3002" ///
									| substr(commoditycode, 1,4)=="3003" | substr(commoditycode, 1,4)=="3004" ///
									| substr(commoditycode, 1,4)=="3005" | substr(commoditycode, 1,4)=="3006" 
		gen food = import_value if substr(commoditycode, 1,2)=="02" | substr(commoditycode, 1,2)=="03" |substr(commoditycode, 1,2)=="04" ///
				| substr(commoditycode, 1,2)=="06" | substr(commoditycode, 1,2)=="07" | substr(commoditycode, 1,2)=="08" ///
				| substr(commoditycode, 1,1)=="1" ///
				| substr(commoditycode, 1,2)=="20" | substr(commoditycode, 1,2)=="21" | substr(commoditycode, 1,2)=="22" ///
				| substr(commoditycode, 1,2)=="24"
		
		//drop if substr(commoditycode, 1,2)=="12" & importer=="ARG"
		collapse (sum) import_value medicine food, by(year importer)
*-------------------------------------------------------------------------------		
		

*-------------------------------------------------------------------------------		
rename importer iso
merge 1:1 year iso using `tempwdi', nogen keep(3 1)
foreach i in import_value medicine food {
		foreach j in index sp_pop_totl { 
			replace `i' = `i' / `j' 
		}
}
*-------------------------------------------------------------------------------		
	
save Fig 5-6.dta, replace 	

	
	 
*-------------------------------------------------------------------------------
// Figure for Medicine imports
*-------------------------------------------------------------------------------
preserve 
	gen temp1 = medicine if year==`benchmarkyear'
	egen temp2 = mean(temp1) , by(iso)
	replace medicine = 100*(medicine/temp2)
	list if iso=="VEN"
	tw (line medicine year if iso=="ARG", lpattern(dash)) ///
	   (line medicine year if iso=="BOL", lpattern(dash)) ///
	   (line medicine year if iso=="BRA", lpattern(dash)) ///
	   (line medicine year if iso=="CHL", lpattern(dash)) ///
	   (line medicine year if iso=="COL", lpattern(dash)) ///
	   (line medicine year if iso=="ECU", lpattern(dash)) ///
	   (line medicine year if iso=="PAN", lpattern(dash)) ///
	   (line medicine year if iso=="PER", lpattern(dash)) ///
	   (line medicine year if iso=="URY", lpattern(dash)) ///
	   (line medicine year if iso=="VEN", lwidth(medthick)) ///
	   , scale(0.9) xlabel(`minyear'(2)`lastyear')  ylabel(0(25)150) ///
	     ytitle("Imports of Medicaments, (Index 100 = year `benchmarkyear')") /// 
	     legen(order( 1  "ARG" 2 "BOL" 3 "BRA" 4  "CHL" 5  "COL" 6  "ECU"  7 "PAN"  8 "PER" 9 "URY" 10 "VEN") pos(6) rows(2))
		 graph export "medicine.pdf", replace 
restore
*-------------------------------------------------------------------------------


*-------------------------------------------------------------------------------
// Figure for food import
*-------------------------------------------------------------------------------
preserve 
	gen temp1 = food if year==`benchmarkyear'
	egen temp2 = mean(temp1) , by(iso)
	replace food = 100*(food/temp2)
		list if iso=="VEN"	
	tw (line food year if iso=="ARG", lpattern(dash)) ///
	   (line food year if iso=="BOL", lpattern(dash)) ///
	   (line food year if iso=="BRA", lpattern(dash)) ///
	   (line food year if iso=="CHL", lpattern(dash)) ///
	   (line food year if iso=="COL", lpattern(dash)) ///
	   (line food year if iso=="ECU", lpattern(dash)) ///
	   (line food year if iso=="PAN", lpattern(dash)) ///
	   (line food year if iso=="PER", lpattern(dash)) ///
	   (line food year if iso=="URY", lpattern(dash)) ///
	   (line food year if iso=="VEN", lwidth(medthick)) ///
	   , scale(0.9) xlabel(`minyear'(2)`lastyear')   ylabel(0(25)125)  ///
	     ytitle("Imports of food, (Index 100 = year `benchmarkyear')") /// 
	     legen(order( 1  "ARG" 2 "BOL" 3 "BRA" 4  "CHL" 5  "COL" 6  "ECU"  7 "PAN"  8 "PER" 9 "URY" 10 "VEN") pos(6) rows(2))
		  graph export "food.pdf", replace 
	*-------------------------------------------------------------------------------
	list 
restore


*-------------------------------------------------------------------------------
// Figure for total imports
*-------------------------------------------------------------------------------
preserve 
	gen temp1 = import_value if year==`benchmarkyear'
	egen temp2 = mean(temp1) , by(iso)
	replace import_value = 100*(import_value/temp2)		
	tw (line import_value year if iso=="ARG", lpattern(dash)) ///
	   (line import_value year if iso=="BOL", lpattern(dash)) ///
	   (line import_value year if iso=="BRA", lpattern(dash)) ///
	   (line import_value year if iso=="CHL", lpattern(dash)) ///
	   (line import_value year if iso=="COL", lpattern(dash)) ///
	   (line import_value year if iso=="ECU", lpattern(dash)) ///
	   (line import_value year if iso=="PAN", lpattern(dash)) ///
	   (line import_value year if iso=="PER", lpattern(dash)) ///
	   (line import_value year if iso=="URY", lpattern(dash)) ///
	   (line import_value year if iso=="VEN", lwidth(medthick)) ///
	   , scale(0.9) xlabel(`minyear'(2)`lastyear')   ylabel(0(25)150)  ///
	     ytitle("Imports, (Index 100 = year `benchmarkyear')") /// 
	     legen(order( 1  "ARG" 2 "BOL" 3 "BRA" 4  "CHL" 5  "COL" 6  "ECU"  7 "PAN"  8 "PER" 9 "URY" 10 "VEN") pos(6) rows(2))
		  graph export "total_imports.pdf", replace 
	
	list 
restore
*-------------------------------------------------------------------------------
